/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTFileSystem;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTFileSystemProvider;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Pair;

public class NBJRTURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(NBJRTURLMapper.class.getName());

    public URL getURL(FileObject fo, int type) {
        if (type == 2) {
            return null;
        }
        try {
            if (fo.getFileSystem() instanceof NBJRTFileSystem) {
                Object path = fo.getPath();
                if (fo.isFolder() && !((String)path).isEmpty()) {
                    path = (String)path + "/";
                }
                return new URL(String.format("%s%s", ((NBJRTFileSystem)fo.getFileSystem()).getRootURL(), path));
            }
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return null;
    }

    public FileObject[] getFileObjects(URL url) {
        Pair<URL, String> parsed = NBJRTUtil.parseURL(url);
        if (parsed != null) {
            FileObject fo;
            URL root = (URL)parsed.first();
            String pathInImage = (String)parsed.second();
            NBJRTFileSystem fs = NBJRTFileSystemProvider.getDefault().getFileSystem(root);
            if (fs != null && (fo = fs.getRoot().getFileObject(pathInImage)) != null) {
                return new FileObject[]{fo};
            }
        }
        return null;
    }
}

